/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.KillEntityData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.trigger.ITriggerHandler;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.common.quests.trigger.TriggerResponseStatus;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class KillEntitiesQuest
extends Quest<KillEntityData> {
    public static final IQuestFactory<KillEntityData, KillEntitiesQuest> FACTORY = IQuestFactory.of(KillEntitiesQuest::new, KillEntitiesQuest::new);
    private int killCount;

    public KillEntitiesQuest(QuestScheme<KillEntityData> scheme, UUID traderId) {
        super(scheme, traderId);
    }

    public KillEntitiesQuest(QuestDeserializationContext<KillEntityData> context) {
        super(context);
    }

    @Override
    protected void fillDataModel(QuestDisplayDataModel model) {
        int required = ((KillEntityData)this.getActiveData()).getKillTarget();
        model.addQuestHeader(this, false);
        model.addInformationRow((ITextComponent)this.getScheme().getDisplayInfo().getInfo(), this, quest -> new StringTextComponent(quest.killCount + "/" + required));
        model.addConditionDisplay(this);
    }

    @Override
    public void registerTriggers(Quest.ITriggerRegistration registration) {
        registration.addEntry(Trigger.ENTITY_KILLED, this::handleEntityKilled, this::onSuccessfulKill);
        registration.addEntry(Trigger.PLAYER_DIED, this::onPlayerDied, ITriggerHandler.NONE);
    }

    @Override
    protected void writeQuestData(CompoundNBT nbt) {
        nbt.func_74768_a("kills", this.killCount);
    }

    @Override
    protected void readQuestData(CompoundNBT nbt) {
        this.killCount = nbt.func_74762_e("kills");
    }

    private TriggerResponseStatus handleEntityKilled(Trigger trigger, IPropertyReader reader) {
        Entity entity = (Entity)reader.getProperty(QuestProperties.ENTITY);
        if (((KillEntityData)this.getActiveData()).getEntityFilter().test(entity)) {
            return TriggerResponseStatus.OK;
        }
        return TriggerResponseStatus.PASS;
    }

    private void onSuccessfulKill(Trigger trigger, IPropertyReader reader) {
        if (++this.killCount >= ((KillEntityData)this.getActiveData()).getKillTarget()) {
            this.setStatus(QuestStatus.COMPLETED);
        }
        this.trySyncClient();
    }

    private TriggerResponseStatus onPlayerDied(Trigger trigger, IPropertyReader reader) {
        return TriggerResponseStatus.FAIL;
    }
}

